-- RK-2 Barrier ATGM by Currenthill

local name_rk2 = 'RK-2 Barrier'

RK_2_BARRIER =
{
    category        = CAT_MISSILES,
    name            = name_rk2,
    user_name       = _(name_rk2),
    model           = 'RK-2_Barrier',
    mass            = 16.0,
    wsTypeOfWeapon  = {4,4,11,WSTYPE_PLACEHOLDER},

    class_name      = "wAmmunitionVikhr",
	scheme			= "command_guided_missile_sfe",
        
    Escort       = 3,
    Head_Type    = 7,
    sigma        = {1, 1, 1}, --aiming error on target
    M            = 16.0, --missile mass in KG
    H_max        = 1500.0, --maximum flight altitude
    H_min        = -1,  --minimum flight altitude
    Diam         = 140.0, --diameter
    Cx_pil       = 1,
    D_max        = 5000.0,  -- maximum launch range at 0 height
    D_min        = 150.0, --minimum launch range
    Head_Form    = 1,
    Life_Time    = 120.0,
    Nr_max       = 55,
    v_min        = 70.0, --minimum speed
    v_mid        = 150.0, --average speed
    Mach_max     = 1.0,
    t_b          = 0.0, --engine start delay time
    t_acc        = 1.0, --engine operating time
    t_marsh      = 10.0, --time in flight
    Range_max    = 5000.0, -- maximum launch range at maximum height (HHQ9: 100km range)
    H_min_t      = 0.0, --minimum target height
    Fi_start     = 3.14152, -- angle of tracking at firing
    Fi_rak       = 3.14152,
    Fi_excort    = 2.0,
    Fi_search    = 99.9, --search angle limit
    OmViz_max    = 99.9, --search line speed limit
	exhaust1 	 = { 0.63, 0.67, 0.75, 0.2 },
    X_back       = -1.325,
    Y_back       = 0.0,
    Z_back       = 0.0,	
	exhaust2 	 = { 0.63, 0.67, 0.75, 0.2 },
	X_back_acc 	 = -1.65,
    Y_back_acc 	 = 0.0,
    Z_back_acc 	 = 0.0,		
	tail_scale 	 = 0.2,	
    Reflection   = 0.01, --effective surface of radio reflection, square meters (like 5V55)
    KillDistance = 0.0,
    ccm_k0       = 0.0,

	controller = {
		boost_start = 0.0,
		march_start = 0.15,
	},
	
	booster = {
		impulse								= 100,
		fuel_mass							= 0.6,
		work_time							= 0.06, 
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0.0, 0.0, 0.0},{0.0, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0},{0.0, 0.0, 0.0}},		
		tail_width							= 0.0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,
	},
	
	march = {
		impulse								= 440,
		fuel_mass							= 3.6,
		work_time							= 3.0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-1.02, 0.0, 0.13},{-1.02, 0.0, -0.13}},
		nozzle_orientationXYZ				= {{0.0, -0.9, 0.0},{0.0, 0.9, 0.0}},
		tail_width							= 0.04,
		smoke_color							= {1.0, 1.0, 1.0},
		smoke_transparency					= 0.013,
		custom_smoke_dissipation_factor		= 0.2,
	},
	
	spiral_nav = {
		t_cone_near_rad			= 3000,
		def_cone_max_dist		= 5000,
		def_cone_near_rad		= 3000,
		def_cone_near_rad_st	= 0,
		def_cone_time_stab_rad	= 0,
		gb_angle				= 0.026, 
		gb_min_dist				= 1,
		gb_use_time				= 0.28,
		gb_max_retW				= 0.5,
		gb_ret_Kp				= 2.5,
	},
		
	autopilot = {
		Kp					= 0.3,
		Ki					= 0.03,
		Kd					= 0.03,
		max_ctrl_angle		= 1.1,
		delay				= 0.2,
		op_time				= 23.0,
		fins_discreet		= 0.01,
		no_ctrl_center_ang	= 0.000035,
	},

	fm = {
		mass        = 21.5,  
		caliber     = 0.152,  
		cx_coeff    = {1,0.28,0.43,0.18,1.12},
		L           = 1.17,
		I           = 1 / 12 * 21.5 * 1.17 * 1.17,
		Ma          = 2.0,
		Mw          = 5.0,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 0.085,
		dCydA		= {0.024, 0.018},
		A			= 0.6,
		maxAoa		= 0.28, 
		finsTau		= 0.05, 
		lockRoll	= 1,
	},

	fuze_proximity = {
		ignore_inp_armed = 0,
		radius = 0
	},

		warhead = {
			mass                 = 6.3, 
			caliber              = 180,
			expl_mass            = 6.3,
			piercing_mass        = 6.3*1.2,
			other_factors        = { 1.0, 1.0, 1.0 },
			concrete_factors     = { 1.0, 1.0, 1.0 },
			concrete_obj_factor  = 0.0,
			obj_factors          = { 1.0, 1.0 },
			cumulative_factor    = 4.0,
			cumulative_thickness = 1.75, 
		},
		
		warhead_air = {
			mass                 = 6.3, 
			caliber              = 180,
			expl_mass            = 6.3,
			piercing_mass        = 6.3*1.2,
			other_factors        = { 1.0, 1.0, 1.0 },
			concrete_factors     = { 1.0, 1.0, 1.0 },
			concrete_obj_factor  = 0.0,
			obj_factors          = { 1.0, 1.0 },
			cumulative_factor    = 4.0,
			cumulative_thickness = 1.75, 
		},		

	err = {
		y_error = 0.01,
		z_error = 0.01,
		min_time_interval = 0.1,
		max_time_interval = 0.1,
	},
	
    shape_table_data = {
        {
            name     = name_rk2,
            file     = 'RK-2_Barrier',
            life     = 1,
            fire     = {0, 1},
            username = name_rk2,
            index    = WSTYPE_PLACEHOLDER,
        },
    },

}

declare_weapon(RK_2_BARRIER)
			
-- ================================== Barrier ATGM ============================================

GT_t.LN_t.BTR4_RK2_Barrier = {name = "RK-2 Barrier", display_name = _("RK-2 Barrier")}
GT_t.LN_t.BTR4_RK2_Barrier.type = 33
GT_t.LN_t.BTR4_RK2_Barrier.distanceMin = 150
GT_t.LN_t.BTR4_RK2_Barrier.distanceMax = 5000
GT_t.LN_t.BTR4_RK2_Barrier.max_trg_alt = 1500
GT_t.LN_t.BTR4_RK2_Barrier.reactionTime = 0.5;
GT_t.LN_t.BTR4_RK2_Barrier.launch_delay = 2.0;
GT_t.LN_t.BTR4_RK2_Barrier.show_external_missile = true
GT_t.LN_t.BTR4_RK2_Barrier.beamWidth = math.rad(0);
GT_t.LN_t.BTR4_RK2_Barrier.reflection_limit = 0.02;
GT_t.LN_t.BTR4_RK2_Barrier.maxShootingSpeed = 0;
GT_t.LN_t.BTR4_RK2_Barrier.sensor = {}
set_recursive_metatable(GT_t.LN_t.BTR4_RK2_Barrier.sensor, GT_t.WSN_t[0])
GT_t.LN_t.BTR4_RK2_Barrier.PL = {}
GT_t.LN_t.BTR4_RK2_Barrier.PL[1] = {}
GT_t.LN_t.BTR4_RK2_Barrier.PL[1].type_ammunition = RK_2_BARRIER.wsTypeOfWeapon;
GT_t.LN_t.BTR4_RK2_Barrier.PL[1].name_ammunition=_("RK-2 Barrier");
GT_t.LN_t.BTR4_RK2_Barrier.PL[1].automaticLoader = false;
GT_t.LN_t.BTR4_RK2_Barrier.PL[1].shot_delay = 1.0;
GT_t.LN_t.BTR4_RK2_Barrier.PL[1].ammo_capacity = 2;
GT_t.LN_t.BTR4_RK2_Barrier.BR = {
                {pos = {0.0, 2.0, 0.0} },
            };			